module ads42jb69

/*
#(
	// Parameter Declarations
	parameter <param_name> = <default_value>,
	parameter [<msb>:<lsb>] <param_name> = <default_value>,
	parameter signed [<msb>:<lsb>] <param_name> = <default_value>
	...
)

*/
(
		
	
	// Input Ports (from usb to cpld)
	input  usb_clk,
	input  usb_data,
	input  usb_enable0,//eeprom enable
	input  usb_oe,
	input  usb_enable1,
	input  usb_enable2, //ads enable
	
	output reg  usb_rdbk,
	
	//Input port(dip switch)
	input [3:0] dipswitch,
	
	//Input Ports (from devices to cpld during readback)
	input rdbk0, //connect to SO pin of eeprom
	input rdbk1, //connect to DATA_IN pin
	input rdbk2, //connect to ads sdout
	
	//Input Port (external CPLD clock)
	input ext_clk, //connect to CPLD_CLK
	
	//Input Port (external reset)
	input ext_reset,
	
	/*
	input wire <port_name>,
	input [<msb>:<lsb>] <port_name>,
	input signed [<msb>:<lsb>] <port_name>,
	...
	*/
	
	
	// Output Ports
	output reg out_enable0, //connect to CS of eeprom
	output reg out_enable1, //connect to SPI_EN
	output reg out_enable2, //connect to spi_en of ads42jb69
	output reg out_clk0,    //connect to SCK of eeprom
	output reg out_clk1,    //connect to SPI_CLK
	output reg out_clk2,		//connect to ads42jb69
	output reg out_data0,   //connect to SI of eeprom
	output reg out_data1,   //connect to DATA_OUT
	output reg out_data2		//connect to ads42jb69
	//added for simulation
/*	
	output [14:0] count,
	output [14:0] index_out,
	output out1,
	output [1:0] change_state1,
	output [7:0] out2,
	output [2:0] countout2
*/
	/*
	output [<msb>:<lsb>] <port_name>,
	output reg [<msb>:<lsb>] <port_name>,
	output signed [<msb>:<lsb>] <port_name>,
	output reg signed [<msb>:<lsb>] <port_name>,
	...
	
	// Inout Ports
	inout <port_name>,
	inout [<msb>:<lsb>] <port_name>,
	inout signed [<msb>:<lsb>] <port_name>
	...
	*/
);

	// Module Item(s)
reg [7:0] usb_interface;
wire counter_enable;
wire [7:0] eeprom_interface, ext_interface;
reg [1:0] change_state;
wire [14:0] count_out;
wire [31:0] read_cmd;
wire shift_enable;
wire [2:0] count_out2;
reg reset_count2;

always @(*)
	usb_interface <= {usb_enable2,usb_enable1,usb_rdbk,usb_oe,usb_enable0,usb_data,usb_clk};
assign read_cmd = {1'b0,8'h03,dipswitch,19'd0};
assign counter_enable=~change_state[1];
assign shift_enable= |change_state;
//assign shift_enable = count_out-'d23;
//added for simulation
/*
	assign count=count_out;
	assign index_out='d31-count_out;
	assign out1=read_cmd['d31-count_out];
	assign change_state1=change_state;
	assign out2=ext_interface;
  assign countout2=count_out2;
*/  
 
// Module instantiation with parameter overrides
shift_register #(8) shift_register1
(
.clk(ext_clk),
.sr_in(rdbk0),
.sr_out(eeprom_interface),
.count(count_out2),
.enable(shift_enable),
.rst(~ext_reset)
);


binary_counter #(15) binary_counter1
(
.clk(ext_clk),
.reset(~ext_reset),
//.enable(ext_reset and counter_enable),
.enable(counter_enable),
.count(count_out)
);

always @(posedge ext_clk)
 reset_count2 <= ~|change_state;

binary_counter #(3) binary_counter2
(
.clk(~ext_clk),
.reset(reset_count2),
.enable(counter_enable),
.count(count_out2)
);


always @(posedge ext_clk or negedge ext_reset)
// always @ (ext_reset or count_out[1])
    begin
      if (~ext_reset)
    begin
        change_state <= 'd0;
   //     shift_enable <= 1'b0;
    //    counter_enable <= 1'b1;
    end        
		else if (count_out>='d24)
			begin
				change_state[0] <= 1'b1;
				change_state[1] <= &count_out[14:1];
	//			shift_enable <=1'b1;
	//			counter_enable <= 1'b1;
			end	
		end
// Basic module instantiation
state_mach state_mach1
(
.state1_out(usb_interface),
.state0_out(eeprom_interface),
.clk(ext_clk),
.reset(~ext_reset),
.in(change_state),
.out(ext_interface)
);
//program the devices
always @(*)
	begin	
		if (&change_state)
		  begin
		     out_enable0 <= ext_interface[2];
			   out_enable1 <= ext_interface[5];
				out_enable2 <= ext_interface[6];//ads42jb69
			   out_clk0 <= ext_interface[0];
				out_clk2 <= ext_interface[0];//ads42jb69
				out_data0 <= ext_interface[1];
				out_data2 <= ext_interface[1];//ads42jb69
				out_data1 <= ext_interface[1];
				out_clk1 <= ext_interface[0];
			end
			
		else if (~|change_state)
		  begin
		    if (count_out == 0)
		      out_clk0 <= 1'b1;
		    else
			    out_clk0 <= ~ext_clk;
			   
			   out_enable0 <= ~ext_reset;
			   out_enable1 <= ext_interface[5];
				out_enable2 <= ext_interface[6];//ads42jb69
				 out_data0 <= read_cmd['d31-count_out];
				 out_data1 <= ext_interface[1];
				 out_data2 <= ext_interface[1];//ads42jb69
				 out_clk1 <= ext_interface[0];
				 out_clk2 <= ext_interface[0];//ads42jb69
			end
			
		else if (^change_state)
			begin
				out_clk0 <= ~ext_clk;
				if (&count_out2)
					begin
						out_enable0 <= ~ext_reset;
						out_enable1 <= ext_interface[5];
						out_enable2 <= ext_interface[6];//ads42jb69
						out_data0 <= 1'b0;
						out_data1 <= ext_interface[1];
						out_data2 <= ext_interface[1];//ads42jb69
						out_clk1 <= ext_interface[0];
						out_clk2 <= ext_interface[0];//ads42jb69
					end
			end
	//		out_data1 <= ext_interface[1];
	//		out_clk1 <= ext_interface[0];
	//	if (~change_state[0])
	//		out_data0 <= read_cmd['d31-count_out];
	//	else
	//		out_data0 <= ext_interface[1];
	end
	

		
	
// Readback Mux

always @ (*)
begin
		if ((~usb_enable0 & usb_oe) /*|| ^change_state*/)
         usb_rdbk <= rdbk0;
      else if (~usb_enable1 & usb_oe)
   		usb_rdbk <= rdbk1;
		else if (~usb_enable2 & usb_oe)
			usb_rdbk <= rdbk2;
		else
			usb_rdbk <= 1'bz;         
end 
	
endmodule
